﻿using Tessa.Cards;
using Tessa.Extensions.WorkflowExamples.Shared.Workflow;
using Tessa.UI.Cards;
using Tessa.UI.WorkflowViewer.Actions;
using Unity;
using Unity.Lifetime;

namespace Tessa.Extensions.WorkflowExamples.Client.Workflow
{
    [Registrator]
    public sealed class Registrator : RegistratorBase
    {
        public override void RegisterUnity()
        {
            this.UnityContainer
                .RegisterType<IWorkflowActionUIHandler, WfeLoanSetStateActionUIHandler>(
                    nameof(WfeHelper.WfeLoanSetStateDescriptor),
                    new ContainerControlledLifetimeManager())
            ;
        }

        public override void RegisterExtensions(IExtensionContainer extensionContainer)
        {
            extensionContainer
                .RegisterExtension<ICardUIExtension, WfeCardUIExtension>(x => x
                    .WithOrder(ExtensionStage.BeforePlatform)
                    .WithSingleton()
                    .WhenCardTypes(WfeHelper.WfeLoanApprovalTypeID))
                ;
        }
    }
}
