﻿#reference Tessa.Extensions.WorkflowExamples.Shared

#using Tessa.Extensions.WorkflowExamples.Shared.Workflow;
#using Tessa.Extensions.WorkflowExamples.Shared.Roles;
#using Tessa.Roles

Process.MainTaskID = this.SignalObject.As<WorkflowEngineTaskSignal>().TaskIDs[0];
var depID = (Guid)Signal.ExpertDepartmentID;
var segmentID = (int)Signal.Segment;

// Метод для получения настроек экспертного подразделения из базы. 
// Вынесен в Helper в расширениях для простоты использования
var info = await WfeWorkflowHelper.GetTaskInfoForDepartmentAsync(DbScope, depID, segmentID);

Process.Digest = info.Item1;
Process.Period = info.Item3 / 8.0;
Process.DepartmentID = depID;

var rolesFormationStrategy = Container.Resolve<IRolesFormationStrategy>();

// GetRolesFormationAsync - Метод для агрегации ролей, указанных как исполнители экспертного подразделения
// GetRoleByDepartmentAsync - Метод для получения исполнителей экспертного подразделения
var role = await rolesFormationStrategy.GetRolesFormationAsync(
    CardID,
    await WfeWorkflowHelper.GetRoleByDepartmentAsync(DbScope, depID, segmentID));

Signal.RoleID = role.Item1;
Signal.RoleName = role.Item2;

// Метод старта экспертизы. Производит первичную запись в основную карточку
Process.ExpertiseID = await WfeWorkflowHelper.StartExpertiseAsync(
	Context,
	(Guid)Process.MainTaskID,
	depID,
	info.Item2,
	info.Item3);
