﻿CREATE FUNCTION "AeGetDepartments"
(
	role_id uuid
)
RETURNS TABLE
(
	"ID" uuid
)
AS $$
    WITH RECURSIVE "RolesCTE" ("ID") AS
	(
		SELECT role_id
		UNION ALL
		SELECT "r"."ID"
		FROM "Roles" AS "r"
		INNER JOIN "RolesCTE" AS "t"
			ON "r"."ParentID" = "t"."ID"
		WHERE "r"."TypeID" = 2
	)
    SELECT DISTINCT
        "r"."ID"
    FROM "RolesCTE" AS "r"
$$
LANGUAGE SQL;