﻿CREATE FUNCTION "AeGetOrganization"
(
	role_id uuid
)
RETURNS TABLE 
(
	"ID" uuid,
	"Name" text
)
AS $$
	WITH RECURSIVE "DepartmentsCTE" ("ID", "ParentID", "HierarchyLevel") AS
	(
		SELECT
			"rc"."ID", "rc"."ParentID", 0 AS "HierarchyLevel"
		FROM "Roles" AS "rc"
		WHERE
			"rc"."TypeID" = 2
			AND "rc"."ID" = role_id
		UNION ALL
		SELECT 
			"rp"."ID", "rp"."ParentID", "dc"."HierarchyLevel" + 1 AS "HierarchyLevel"
		FROM "Roles" AS "rp"
		INNER JOIN "DepartmentsCTE" AS "dc"
			ON "dc"."ParentID" = "rp"."ID"
		WHERE "rp"."TypeID" = 2
	)
	SELECT
		"aco"."ID", "aco"."Name"
	FROM "DepartmentsCTE" AS "dc"
	INNER JOIN "Roles" AS "r"
		ON "r"."ID" = "dc"."ID"
	INNER JOIN "AclDepartmentRoles" AS "acd"
		ON "acd"."ID" = "r"."ID"
	INNER JOIN "AclOrganization" as "aco"
		ON "aco"."DepartmentID" = "r"."ID"
	WHERE "acd"."DepartmentTypeID" = 0
	ORDER BY "dc"."HierarchyLevel" ASC
	LIMIT 1;
$$
LANGUAGE SQL;