﻿using Tessa.Cards;
using Tessa.Extensions.AclExamples.Shared;
using Tessa.UI.Cards;
using Unity;
using Unity.Lifetime;

namespace Tessa.Extensions.AclExamples.Client.UI
{
    [Registrator]
    public class Registrator : RegistratorBase
    {
        #region Base Overrides

        public override void RegisterUnity()
        {
            this.UnityContainer
                .RegisterType<ICardUIExtension, MeetingProtocolUIExtension>(new ContainerControlledLifetimeManager());
        }

        public override void RegisterExtensions(IExtensionContainer extensionContainer)
        {
            extensionContainer

                // Store
                .RegisterExtension<ICardUIExtension, MeetingProtocolUIExtension>(x => x
                    .WithOrder(ExtensionStage.AfterPlatform, 0)
                    .WithUnity(this.UnityContainer)
                    .WhenCardTypes(AclExamplesCardTypes.AclMeetingProtocolTypeID))
                ;
        }

        #endregion
    }
}