﻿using System;
using System.Collections.Generic;
using System.Threading;
using System.Threading.Tasks;

namespace Tessa.Extensions.AclExamples.Server.Roles
{
    /// <summary>
    /// Провайдер списка типов документов, используемых в настройках подразделений по типам документов.
    /// </summary>
    public interface IDepartmentSettingsDocTypesProvider
    {
        /// <summary>
        /// Возвращает список типов документов, для которых возможны настройки подразделений по типам документов.
        /// </summary>
        /// <param name="cancellationToken">Объект, посредством которого можно отменить асинхронную задачу.</param>
        /// <returns>Список типов документов, для которых возможны настройки подразделений по типам документов.</returns>
        ValueTask<IList<(Guid, string)>> GetAllDocTypesAsync(CancellationToken cancellationToken = default);
    }
}
